﻿unit uZależnośćZgłaszającaWyjątek;

interface

uses
  SysUtils;

type
  IWidżet = interface(IInvokable)
    function Dobry: Boolean;
  end;

  TWidget = class(TInterfacedObject, IWidżet)
  public
    function Dobry: Boolean;
  end;

  IProcesorWidżetów = interface(IInvokable)
    procedure PrzetwarzajWidżet(aWidżet: IWidżet);
  end;

  TProcesorWidżetów = class(TInterfacedObject, IProcesorWidżetów)
  public
    procedure PrzetwarzajWidżet(aWidżet: IWidżet);
  end;

  EWyjątekZłyWidżet = class(Exception);

implementation

procedure TProcesorWidżetów.PrzetwarzajWidżet(aWidżet: IWidżet);
begin
  try
    if aWidżet.Dobry then
    begin
      WriteLn('Widżet został poprawnie przetworzony');
    end;
  except
    On E: EWyjątekZłyWidżet do
    begin
      WriteLn('Metoda "Dobry" nie mogła zweryfikować widżetu');
    end;
  end;
end;

function TWidget.Dobry: Boolean;
begin
  // Na potrzeby przykładu załóżmy, że widżety od 1 do 100 są złe
  // Jednak poniższy kod nigdy nie będzie wywołany, ponieważ będzie imitowany
  Result := Random(100) >= 99;
  if not Result then
  begin
    raise EWyjątekZłyWidżet.Create('Zły widżet, bardzo zły!');
  end;
end;

end.

